package listFW;

/**
 * Represents the structural behavior of an immutable non-empty list.
 * An immutable non-empty list has a data object called first, and an
 * isomorphic subcomponent called rest.  Its structural behavior
 * provides access to its internal data (first) and substructure (rest).
 * @author Dung X. Nguyen
 * @author Stephen B. Wong
 * @since Copyright 2002 - DXN, SBW All rights reserved
 */
public interface INEList extends IList {
    /**
     * "Gettor" method for the list's first.
     * @return this <code>INElist</code>'s first element.
     */
    public abstract Object getFirst();

    /**
     * "Gettor" method for the list's rest.
     * @return this <code>INElist</code>'s rest.
     */
    public abstract IList getRest();
}

