package listFW.visitor;
import listFW.*;

/**
 * Computes the length of a list using anonymous inner class.
 * @author D. X. Nguyen
 * @since Copyright 2005 - DXN All rights reserved
 */
public class Length implements IListAlgo {

    public static final Length Singleton = new Length();
    private Length() {
    }

    /**
     * Returns 0 because the empty list has no element.
     * @param host an empty list.
     * @param nu not used.
     * @return Integer
     */
    public Object emptyCase(IEmptyList host, Object... nu) {
        return 0;
    }


    /**
     * Passes the accumulated length (1) to the rest
     * and asks an annonymous inner class for help to
     * compute the length.
     * @param host a non-empty list.
     * @param nu not used.
     * @return Integer
     */
    public Object nonEmptyCase(INEList host, Object... nu) {
        // call helper as an anonymous inner class:
        return host.getRest().execute(new IListAlgo() {

            public Object emptyCase(IEmptyList h, Object... acc) {
                return acc[0];
            }

            public Object nonEmptyCase(INEList h, Object... acc) {
                return h.getRest().execute(this, 1 + (Integer)acc[0]);
            }
        },  // end of anonymous inner class.
        1);  // pass accumulated length of 1 to helper.
    }
}