package lrs.visitor;
import lrs.*;

/**
 * Makes the host share the same head node with the input list.
 * The input list does not change.
 * In the end, both host and the input list share the same head node.
 */
public class Share implements IAlgo {
  public final static Share Singleton = new Share ();
  private Share() {
  }
  
  /**
   * @param input a LRStruct;
   * @return null
   */
  public Object emptyCase(LRStruct host, Object... input) {
    return assign(host, (LRStruct)input[0]);
  }
  
  /**
   * @param input a LRStruct;
   * @return null
   */
  public Object nonEmptyCase(LRStruct host, Object... input) {
    return assign(host, (LRStruct)input[0]);
  }
  
  /**
   * "Assigns the LRStruct on the right-hand-side, rhs, 
   * to the LRStruct on the left-hand-side, lhs, so that
   * in the end, they both share the same head node.
   */
  private Object assign (LRStruct lhs, LRStruct rhs) {
    lhs.insertFront (null);
    lhs.setRest (rhs);
    lhs.removeFront();
    return null;
  }
}

