package lrs.visitor.test;

import junit.framework.TestCase;
import lrs.*;
import lrs.visitor.*;
/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_Zipper extends TestCase {
  
  IAlgo algo = Zipper.Singleton;
  
  public void test_zipper() {
    LRStruct lrs1 = new LRStruct();
    LRStruct lrs2 = new LRStruct();
    lrs1.execute(algo, lrs2);
    
    assertEquals("2 empty lists", "()", lrs1.toString());
    assertEquals("2 empty lists", "()", lrs2.toString());
    
    
    lrs1.insertFront("a");
    
    lrs1.execute(algo, lrs2);    
    assertEquals("1 empty lists", "(a)", lrs1.toString());
    assertEquals("1 empty lists", "(a)", lrs2.toString());
    
    lrs1 = new LRStruct();
    
    lrs1.execute(algo, lrs2);    
    assertEquals("1 empty lists", "(a)", lrs1.toString());
    assertEquals("1 empty lists", "(a)", lrs2.toString());
    
    
    lrs1 = new LRStruct();
    lrs1.insertFront("b");
    
    lrs1.execute(algo, lrs2);    
    assertEquals("2 1-element lists", "(b a)", lrs1.toString());
    assertEquals("2 1-element lists", "(b a)", lrs2.toString());
    
    lrs1 = new LRStruct();
    lrs1.insertFront("c");
 
    lrs1.execute(algo, lrs2);    
    assertEquals("1 and 2 element lists", "(c b a)", lrs1.toString());
    assertEquals("1 and 2 element lists", "(c b a)", lrs2.toString());
     
    lrs1 = new LRStruct();
    lrs1.insertFront("b");
    lrs1.insertFront("a");
 
    lrs2 = new LRStruct();
    lrs2.insertFront("c");

    lrs1.execute(algo, lrs2);    
    assertEquals("2 and 1 element lists", "(a c b)", lrs1.toString());
    assertEquals("2 and 1 element lists", "(a c b)", lrs2.toString());

    lrs1 = new LRStruct();
    lrs1.insertFront("b");
    lrs1.insertFront("a");
 
    lrs2 = new LRStruct();
    lrs2.insertFront("d");
    lrs2.insertFront("c");

    lrs1.execute(algo, lrs2);    
    assertEquals("2 and 2 element lists", "(a c b d)", lrs1.toString());
    assertEquals("2 and 2 element lists", "(a c b d)", lrs2.toString());
  }
  
}
