package elec;

/**
 * Represents a battery with an output wire.
 * The ground wire is implicit, so only one wire is defined.
 */
public class Battery implements IWire {
  /**
   * The battery's voltage
   */
  private int _voltage;
  
  /**
   * Constructor for the class
   * @param voltage  The voltage of this battery
   */
  public Battery(int voltage) {
    _voltage = voltage;
  }
  
  /**
   * Get the voltage from the battery's output wire
   */
  public int getVoltage() {
    return _voltage;
  }
}