package elec;

/**
 * Represents a switch with one input wire and two output terminals.
 * When the switch is UP, the input wire is connected to the UP output terminal.
 * When the switch is DOWN, the input wire is connected to the DOWN output terminal.
 */
public class One2TwoSwitch implements ITwoWaySwitch{
  /**
   * The input wire to the switch
   */
  private IWire inputWire;
  /**
   * The current state of the switch
   */
  private AOne2TwoSwitchState state = new One2TwoSwitchUpState();
  
  /**
   * The constructor for the class
   * @param wire The input wire to the switch
   */
  public One2TwoSwitch(IWire wire) {
    inputWire = wire;
  }
  
  /**
   * Set the switch to UP
   */
  public void setUp() {
    state = new One2TwoSwitchUpState();
  }
  
  /**
   * Set the switch to DOWN
   */
  public void setDown() {
    state = new One2TwoSwitchDownState();
  }
  
  /**
   * The voltage on the UP Terminal
   */
  public int getVoltageUp() {
    return state.getVoltageUp(inputWire);
  }

  /**
   * The voltage on the DOWN terminal
   */
  public int getVoltageDown() {
    return state.getVoltageDown(inputWire);
  }
}

/**
 * Abstract  state of the switch
 */
abstract class AOne2TwoSwitchState {
  
  /**
   * Gets the output voltage on the UP terminal
   * @param wire  The input wire to the switch
   */
  abstract int getVoltageUp(IWire wire);

  /**
   * Gets the output voltage on the DOWN terminal
   * @param wire  The input wire to the switch
   */
  abstract int getVoltageDown(IWire wire);
}

/**
 * UP state of the switch
 */
class One2TwoSwitchUpState extends AOne2TwoSwitchState {
  /**
   * returns the voltage on the input wire
   */
  int getVoltageUp(IWire wire) {
    return wire.getVoltage();
  }
  
  /**
   * Returns 0 volts, always (disconnected)
   */
  int getVoltageDown(IWire wire) {
    return 0;
  }
}

/**
 * DOWN state of the switch
 */
class One2TwoSwitchDownState extends AOne2TwoSwitchState {
  /**
   * Returns 0 volts, always (disconnected)
   */
  int getVoltageUp(IWire wire) {
    return 0;
  }
  
  /**
   * returns the voltage on the input wire
   */
  int getVoltageDown(IWire wire) {
    return wire.getVoltage();
  }
}
