package elec;

/**
 * A wire that connects to the DOWN terminal of a One2TwoSwitch
 */
public class SwitchDownWire implements IWire {
  /**
   * The switch the wire is connected to
   */
  private One2TwoSwitch one2TwoSwitch;
  
  /**
   * The constructor for the class
   * @param the One2TwoSwitch whose DOWN terminal this wire connects to.
   */
  public SwitchDownWire(One2TwoSwitch one2TwoSwitch) {
    this.one2TwoSwitch =one2TwoSwitch;
  }
  
  /**
   * The voltage on the DOWN terminal of the One2TwoSwitch
   */
  public int getVoltage() {
    return one2TwoSwitch.getVoltageDown();
  }
  
}