package elec;

/**
 * A wire that connects to the UP terminal of a One2TwoSwitch
 */
public class SwitchUpWire implements IWire {
  /**
   * The switch the wire is connected to
   */
  private One2TwoSwitch one2TwoSwitch;
  
  /**
   * The constructor for the class
   * @param the One2TwoSwitch whose UP terminal this wire connects to.
   */
  public SwitchUpWire(One2TwoSwitch one2TwoSwitch) {
    this.one2TwoSwitch =one2TwoSwitch;
  }
  
  /**
   * The voltage on the UP terminal of the One2TwoSwitch
   */
  public int getVoltage() {
    return one2TwoSwitch.getVoltageUp();
  }
  
}