package elec;

/**
 * A 3-way switch system has two 2-way switches, switch A and switch B,
 * that can be set UP or DOWN independently.
 * A 3-way switch has one input wire and one output wire.
 * The voltage on the output wire depends on the voltage of the
 * input wire and how the 2-way switches are set.
 */
public class ThreeWaySwitch implements IWire{
  private One2TwoSwitch switchA;
  private Two2OneSwitch switchB;
  
  /**
   * Constructor for the class
   * @param inputWire   The input wire to the 3-way switch
   */
  public ThreeWaySwitch(IWire inputWire) {
    switchA = new One2TwoSwitch(inputWire);
    IWire wireUp = new SwitchUpWire(switchA);
    IWire wireDown = new SwitchDownWire(switchA);
    switchB = new Two2OneSwitch(wireUp, wireDown);
  }
  
  /**
   * Set switch A to UP
   */
  public void setSwitchAUp() {
    switchA.setUp();
  }
  
  /**
   * Set switch A to DOWN
   */
  public void setSwitchADown() {
    switchA.setDown();
  }

  /**
   * Set switch B to UP
   */
  public void setSwitchBUp() {
    switchB.setUp();
  }

  
  /**
   * Set switch B to DOWN
   */
  public void setSwitchBDown() {
    switchB.setDown();
  }
  
  /**
   * Get the voltage on the output wire
   */
  public int getVoltage() {
    return switchB.getVoltage();
  }
}