package elec;

/**
 * Represents a switch that has two input wires and one output wire
 * When the switch is UP, the wireUp is connected to the output wire.
 * When the switch is DOWN, the wireDown is connected to the output wire.
 */
public class Two2OneSwitch implements ITwoWaySwitch, IWire{
  /**
   * The UP input wire
   */
  private IWire wireUp;
  /**
   * The DOWN input wire
   */
  private IWire wireDown;
  /**
   * The current state of switch
   */
  private ATwo2OneSwitchState state = new Two2OneSwitchUpState();
  
  /**
   * Constructor for the class
   * @param wireUp  The wire that is connected when the switch is UP.
   * @param wireDown The wire that is connecte when the switch is DOWN.
   */
  public Two2OneSwitch(IWire wireUp, IWire wireDown) {
    this.wireUp = wireUp;
    this.wireDown = wireDown;
  }
  
  /**
   * Set the switch to UP
   */
  public void setUp() {
    state = new Two2OneSwitchUpState();
  }
  
  /**
   * Set the switch to DOWN
   */
  public void setDown() {
    state = new Two2OneSwitchDownState();
  }
  
  /**
   * Get the voltage on the output wire
   */
  public int getVoltage() {
    return state.getVoltage(wireUp, wireDown);
  }
}

/**
 * Abstract  state of the switch
 */
abstract class ATwo2OneSwitchState {
  /**
   * Returns the voltage on the output wire of the switch
   * @param wireUp   The UP input wire
   * @param wireDown  The DOWN input wire
   */
  abstract int getVoltage(IWire wireUp, IWire wireDown);
}

/**
 * UP state of the switch
 */
class Two2OneSwitchUpState extends ATwo2OneSwitchState {
  /**
   * Returns the voltage on the UP input wire
   */
  int getVoltage(IWire wireUp, IWire wireDown) {
    return wireUp.getVoltage();
  }
}

/**
 * DOWN state of the switch
 */
class Two2OneSwitchDownState extends ATwo2OneSwitchState{
  /**
   * Returns the voltage on the DOWN input wire
   */
  int getVoltage(IWire wireUp, IWire wireDown) {
    return wireDown.getVoltage();
  }
}
