package fp;

/**
* An example of a lambda function that adds a specified String onto the front of the String 
* representation of the given object.
* Example usage:  aList.map(new AddString("The value is ")); 
* This will return a new list with every element a String of the form
* "The value is "+_first.toString():
* (2, -1, 10) ? (The value is 2, The value is -1, The value is 10)
*/
public class AddString implements ILambda{
   private String _stringToAdd;

   public AddString(String stringToAdd) {
      _stringToAdd = stringToAdd;
   }

   public Object apply(Object x) {
     return _stringToAdd + x.toString();
   }
} 


