package fp;

/**
* An example of a lambda function that multiplies the input object, assumed to be an integer,
* by a specified multiplier.
* Example usage:  aList.map(new Multiplier(42)); 
* This will return a new list with every element multiplied by 42, for example:
* (2, -1, 10) ? (84, -42, 420)
*/
public class MultiplyBy implements ILambda{
   private int _multiplier;

   public MultiplyBy(int multiplier) {
      _multiplier = multiplier;
   }

   public Object apply(Object x) {
     return _multiplier*(Integer) x;
   }
} 


