package listFW;
import fp.*;

/**
 * Represents the abstract list structure.
 */
public interface IList {
  
  /**
   * Return a String with the String representations of all the elements
   * in reverse order.
   */
  public String backwards();
  
  /**
   * Alternate implementation of backwards.
   */
  public String backwards_alt();
  
  /**
   * Helper method for the alternate implementation of backwards.
   */
  public String backwards_alt_help(String acc);
  
  /**
   * Applies the given lambda on every element of the list, returning a new list 
   * with the new values.   That is, the new first values are lambda.apply(_first).
   */
  public abstract IList map(ILambda lambda);
  
  public String toString_Help(String acc);
}
