package listFW;
import fp.*;

/**
 * Represents non-empty lists.
 */
public class NEList implements IList {
  private Object _first;
  private IList _rest;
  
  public NEList(Object f, IList r) {
    _first = f;
    _rest = r;
  }
  
  /**
   * Return a String with the String representations of all the elements
   * in reverse order.
   */
  public String backwards() {
    // Part b) STUDENT TO COMPLETE (10 pts)
    return  _rest.backwards()+_first;
  }
  
  public String backwards_alt() {
    return _rest.backwards_alt_help(_first.toString());
  }
  
  public String backwards_alt_help(String acc) {
    return _rest.backwards_alt_help(_first.toString()+acc);
  }
  
  /**
   * Applies the given lambda on every element of the list, returning a new list 
   * with the new values.   That is, the new first values are lambda.apply(_first).
   */
  public IList map(ILambda lambda) {
    // Part d) STUDENT TO COMPLETE (15 pts)
    return new NEList(lambda.apply(_first), _rest.map(lambda));
  }

  public String toString() {
    return _rest.toString_Help("("+_first);
  }
  public String toString_Help(String acc) {
    return _rest.toString_Help(acc+", "+_first);
  }

  
}
