
package sorter;

/**
 * A concrete sorter that uses the Bubble Sort technique.
 */
public class BubbleSorter extends ASorter
{
  
  /**
   * The constructor for this class.
   * @param iCompareOp The comparison strategy to use in the sorting.
   */
  public BubbleSorter(AOrder iCompareOp)
  {
    super(iCompareOp);
  }
  
  /**
   * Splits A[lo:hi] into A[lo:s-1] and A[s:hi] where s is the returned value of this function.
   * This method bubbles the "smallest" value to the lo end and splits it off.
   * @param A the array A[lo:hi] to be sorted.
   * @param lo the low index of A.
   * @param hi the high index of A.
   * @return lo+1 always.
   */
  protected int split(Object[] A, int lo, int hi)
  {
    for(int j = hi; lo < j; j--) {
      if (aOrder.lt(A[j],A[j-1])) {  // Check if A[j] < A[j-1]
        Object temp = A[j];        // Swap the the neighboring values
        A[j] = A[j-1];
        A[j-1] = temp;
      }
    }
    return lo + 1;    
  }
  
  /**
   * Joins sorted A[lo:s-1] and sorted A[s:hi] into A[lo:hi].
   * This method does nothing.  The sub-arrays are already in proper order.
   * @param A A[lo:s-1] and A[s:hi] are sorted.
   * @param lo the low index of A.
   * @param s 
   * @param hi the high index of A.
   */
  protected void join(Object[] A, int lo, int s, int hi)
  {
  }
}

