package array.test;
import junit.framework.TestCase;
import array.*;
import java.util.*;

/**
 */
public class TestArrayUtils extends TestCase {
    static ArrayUtils au = ArrayUtils.Singleton;
    
    static Object[] a0 = new Object[0];
    static Object[] b0 = new Object[0];
    static Object[] a1 = {'a'};
    static Object[] b1 = {'b'};
    static Object[] a2 = {"A1", "A2", "A3"};
    static Object[] b2 = {"B1", "B2", "B3", "B4"};
    
    static Object[][] m0 = {};
    static Object[][] m00 = {{}};
    static Object[][] m1 = {{}, {}, {}};
    static Object[][] m2 = {{1}, {}, {2, 3, 4}, {'a', 'b'}};
    static Object[][] m3 = {{1, 2}, {3}, {4, 5, 6}, {'a', 'b'}};
    
    
    /**
     */
    public void test_countElements() {
        System.out.println("m0 count: " + au.countElements(m0));
        assertEquals("m0 count: ", 0, au.countElements(m0));
        
        System.out.println("m00 count: " + au.countElements(m00));
        assertEquals("m00 count: ", 0, au.countElements(m00));
        
        System.out.println("m1 count: " + au.countElements(m1));
        assertEquals("m1 count: ", 0, au.countElements(m1));
        
        System.out.println("m2 count: " + au.countElements(m2));
        assertEquals("m2 count: ", 6, au.countElements(m2));
    }   

    public void test_copyArray() {
        // srcLo < 0
        try {
            System.out.println("Copy " + 0 + " elements from " + Arrays.toString(a1) + 
                               " at " + -1
                                   + " to " + Arrays.toString(b1) + " at 0");
            au.copyArray(a1, -1, 0, b1, 0);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            assertTrue(e instanceof IllegalArgumentException);
        }
        catch (Exception e) {
            fail("Wrong exception: " + e);
        }
        
        // srcLo > src.length - 1
        try {
            System.out.println("Copy " + 0 + " elements from " + Arrays.toString(a1) + 
                           " at " + 1
                               + " to " + Arrays.toString(b1) + " at 0");
            au.copyArray(a1, 1, 0, b1, 0);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            assertTrue(e instanceof IllegalArgumentException);
        }
        catch (Exception e) {
            fail("Wrong exception: " + e);
        }
        
        // destLo < 0
        try {
            System.out.println("Copy " + 0 + " elements from " + Arrays.toString(a1) + 
                           " at " + 0
                               + " to " + Arrays.toString(b1) + " at -1");
            au.copyArray(a1, 0, 0, b1, -1);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            assertTrue(e instanceof IllegalArgumentException);
        }        
        catch (Exception e) {
            fail("Wrong exception: " + e);
        }
        
        // destLo > dest.length - 1
        try {
            System.out.println("Copy " + 0 + " elements from " + Arrays.toString(a1) + 
                           " at " + 0
                               + " to " + Arrays.toString(b1) + " at 1");
            au.copyArray(a1, 0, 0, b1, 1);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            assertTrue(e instanceof IllegalArgumentException);
        }
        catch (Exception e) {
            fail("Wrong exception: " + e);
        }
        
        // maxElements < 0: do nothing
        try {
            System.out.println("Copy " + -1 + " elements from " + Arrays.toString(a1) + 
                           " at " + 0
                               + " to " + Arrays.toString(b1) + " at 0");
            au.copyArray(a1, 0, -1, b1, 0);
            System.out.println("Do nothing: a1 = " + Arrays.toString(a1) + 
                               " b1 = " + Arrays.toString(b1));
            assertTrue(Arrays.equals(b1, new Object[]{'b'}));
        }
        catch (Exception e) {
            fail("Should not throw exception: " + e);
        }
        
        // others      
        System.out.println("Copy " + 2 + " elements from " + Arrays.toString(a2) + 
                           " at " + 1
                               + " to " + Arrays.toString(b1) + " at 0");
        au.copyArray(a2, 1, 2, b1, 0);
        System.out.println("After copy: a2 = " + Arrays.toString(a2) + 
                           " b1 = " + Arrays.toString(b1));
        assertTrue(Arrays.equals(b1, new Object[]{"A2"}));

        System.out.println("Copy " + 2 + " elements from " + Arrays.toString(a2) + 
                           " at " + 1
                               + " to " + Arrays.toString(b2) + " at 2");
        au.copyArray(a2, 1, 2, b2, 2);
        System.out.println("After copy: a2 = " + Arrays.toString(a2) + 
                           " b2 = " + Arrays.toString(b2));
        assertTrue(Arrays.equals(b2, new Object[]{"B1", "B2", "A2", "A3"}));
    }
    
    public void test_matrix2array() {
        Object[] result = au.matrix2array(m0);
        System.out.println("matrix2array: " + Arrays.deepToString(m0) + " -> " + Arrays.toString(result));
        assertTrue(Arrays.equals(result, new Object[0]));
        
        result = au.matrix2array(m00);
        System.out.println("matrix2array: " + Arrays.deepToString(m00) + " -> " + Arrays.toString(result));
        assertTrue(Arrays.equals(result, new Object[0]));

        result = au.matrix2array(m1);
        System.out.println("matrix2array: " + Arrays.deepToString(m1) + " -> " + Arrays.toString(result));
        assertTrue(Arrays.equals(result, new Object[0]));
        
        result = au.matrix2array(m2);
        System.out.println("matrix2array: " + Arrays.deepToString(m2) + " -> " + Arrays.toString(result));
        assertTrue(Arrays.equals(result, new Object[]{1, 2, 3, 4, 'a', 'b'}));

        result = au.matrix2array(m3);
        System.out.println("matrix2array: " + Arrays.deepToString(m3) + " -> " + Arrays.toString(result));
        assertTrue(Arrays.equals(result, new Object[]{1, 2, 3, 4, 5, 6, 'a', 'b'}));
    }
}
