package brs.visitor.test;
import brs.*;
import brs.visitor.*;
import rac.*;
import listFW.*;
import listFW.factory.*;

import junit.framework.TestCase;

/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class Test_RACTraverse extends TestCase {
  
  IVisitor algo = RACTraverse.Singleton;
  IRACFactory stackFac = new LRSStackFactory();
  IRACFactory queueFac = new LRSQueueFactory();
  
  public void test_emptyBRS() {
    BiTree brs = new BiTree();
    
    IRAContainer rac = queueFac.makeRAC();
    
    assertEquals("Empty BRS + queue", "()", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());

    rac = stackFac.makeRAC();
    
    assertEquals("Empty BRS + stack", "()", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
    
  }

  
  public void test_LeafBRS() {
    BiTree brs = new BiTree();    
    brs.insertRoot("a");
    
    IRAContainer rac = queueFac.makeRAC();    
    assertEquals("1 elt BRS + queue", "(a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());

    rac = stackFac.makeRAC();    
    assertEquals("1 elt BRS + stack", "(a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
    
  }

  
  public void test_2eltBRS() {
    BiTree brs = new BiTree();   
    brs.insertRoot("a");  
    brs.getLeftSubTree().insertRoot("b");
    
    IRAContainer rac = queueFac.makeRAC();  
    assertEquals("2 elt BRS + queue", "(a, b)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());

    rac = stackFac.makeRAC(); 
    assertEquals("2 elt BRS + stack", "(b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());

    
    brs = new BiTree();    
    brs.insertRoot("a");
    brs.getRightSubTree().insertRoot("b");
    
    rac = queueFac.makeRAC();   
    assertEquals("2 elt BRS + queue", "(a, b)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());

    rac = stackFac.makeRAC();    
    assertEquals("2 elt BRS + stack", "(b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
    
  }

  
  public void test_3eltBRS() {
    BiTree brs = new BiTree();   
    brs.insertRoot("a");  
    brs.getLeftSubTree().insertRoot("b");
    brs.getRightSubTree().insertRoot("c");
    
    IRAContainer rac = queueFac.makeRAC();  
    assertEquals("3 elt BRS + queue", "(a, b, c)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());

    rac = stackFac.makeRAC(); 
    assertEquals("3 elt BRS + stack", "(c, b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
  }  

  public void test_6eltBRS() {
    BiTree brs = new BiTree();   
    brs.insertRoot("a");  
    brs.getLeftSubTree().insertRoot("b");
    brs.getRightSubTree().insertRoot("c");
    brs.getLeftSubTree().getLeftSubTree().insertRoot("d");
    brs.getLeftSubTree().getRightSubTree().insertRoot("e");
    brs.getRightSubTree().getLeftSubTree().insertRoot("f");
    brs.getRightSubTree().getRightSubTree().insertRoot("g");
    
    IRAContainer rac = queueFac.makeRAC();  
    assertEquals("6 elt BRS + queue", "(a, b, d, e, c, f, g)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());

    rac = stackFac.makeRAC(); 
    assertEquals("6 elt BRS + stack", "(g, f, c, e, d, b, a)", ((IRAContainer)brs.execute(algo, rac)).elements(CompositeListFactory.Singleton).toString());
  }  
}
