package listFW;

/**
 * Serves as a host for an algorithm on a list to visit its internal structure.
 * Has a "hook" method to call on the appropriate method of the visitor, making
 * the immutable list structure a framework.
 * @author Dung X. Nguyen
 * @author Stephen B. Wong
 * @since Copyright 2002 - DXN, SBW All rights reserved
 * @dependency listFW.IListAlgo calls on
 */
public interface IList {
    /**
     * A visitor pattern "hook" method that executes an <code>IListAlgo</code>.
     * @param algo the visitor, the algorithm to be executed.
     * @param inp input parameters to be used by the algorithm algo.
     * @return <code>Object</code> output from executing the algorithm algo.
     */
    public abstract Object execute(IListAlgo algo, Object... inp);
}

