package listFW;

/**
 * Abstract factory to manufacture IEmptyList and INEList.
 * @author Dung X. Nguyen
 * @author Stephen B. Wong
 * @since Copyright 2002 - DXN, SBW All rights reserved
 * @dependency listFW.IList uses
 * @dependency listFW.IEmptyList instantiates
 * @dependency listFW.INEList 
 */
public interface IListFactory {
    /**
     * Creates an empty list.
     * @return an IEmptyList object.
     */
    public abstract IEmptyList makeEmptyList();


    /**
     * Creates a non-empty list containing a given first and a given rest.
     * @param first a data object.
     * @param tail != null, the rest of the non-empty list to be manufactured.
     * @return an INEList object containing first and tail
     * @exception IllegalArgumentException if tail is null.
     */
    public abstract INEList makeNEList(Object first, IList tail);
}