package lrs;

/**
 * Represents the empty state of a mutable list LRStruct. Uses the
 * Singleton pattern.
 * @author Dung X. Nguyen  Copyright 2005 - All rights reserved.
 * @since 02/09/05
 */
class EmptyNode extends ANode {
    /**
     * Singleton Pattern.
     */
    final static EmptyNode Singleton = new EmptyNode();
    private EmptyNode() {
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct getRest(LRStruct owner) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    Object getFirst(LRStruct owner) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct setRest(LRStruct owner, LRStruct tail) {
        throw new java.util.NoSuchElementException ("Empty list has no tail.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct setFirst(LRStruct owner, Object dat) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * The owner becomes non-empty and has dat as its first element.
     */
    LRStruct insertFront(LRStruct owner, Object dat) {
        return owner.setHead(new NENode(dat, new LRStruct(this)));
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    Object removeFront(LRStruct owner) {
        throw new java.util.NoSuchElementException ("Empty list has no front.");
    }

    /**
    * Calls the <code>IAlgo</code> visitor's empty case.
    */
    Object execute(LRStruct owner, IAlgo algo, Object... inp)  {
        return algo.emptyCase(owner, inp);
    }
}

