package kochModel.factory;
import java.awt.geom.Point2D;
import java.awt.*;

/**
 * A "wrapper" class that is used to transport more than one object into an IAlgo algorithm.  This class
 * carries an AffineXForm object and the previous point that was accessed.
 *
 */
class AffineData
{
	/**
	 * The Affine transform object that will be used to transform the prototype coordinates (in Double) into screen coordinates.
	 */
	private AffineXForm affineXForm;
	/**
	 * The previous point that was processed.
	 */
	private Point2D.Double x = new Point2D.Double();

	/**
	 * Constructs a new AffineData instance based on the supplied endpoints.
	 * @param a The first endpoint
	 * @param b The last endpoint.
	 * @SBGen Constructor
	 */
	AffineData(Point a, Point b)
	{
		Point2D.Double delta = new Point2D.Double((double)(b.x-a.x), (double)(b.y-a.y));
		Point2D.Double a2 = new Point2D.Double((double) a.x, (double) a.y);
		affineXForm = new AffineXForm(a2, delta);
	}

	/**
	 * Accessor method for the previous element prcessed.
	 * @param x The value to set the property school.
	 * @SBGen Method set x
	 */
	public void setX(Point2D.Double x)
	{
		// SBgen: Assign variable
		this.x = x;
	}

	/**
	 * Accessor method for X.
	 * @return The value of  the property x.
	 * @SBGen Method get x
	 */
	public Point2D.Double getX()
	{
		// SBgen: Get variable
		return(x);
	}

	/**
	 * Takes the supplied Point2d.Double point and returns a regular Point object that is the Affine transform of that point.
	 * @param x The point to be transformed.
	 * @return The Affine transform of x
	 */
	Point doXForm(Point2D.Double x)
	{
		Point2D.Double x2 = affineXForm.doXForm(x);
		return new Point( (int)Math.round( x2.x), (int)Math.round(x2.y));
	}
}

