package parser;

import rules.*;
import tokens.*;

public class AFact extends ATVFactory {
    private XFact xFact;
    private ITokVisitor _parseX;
    
    private ILambda _initializer = new ILambda() {
        public Object apply(Object nu) {
            _initializer = NoOpLambda.Singleton;
            _parseX = xFact.makeVisitor();
            return null;
        }
    };
    
    public AFact(ITokenizer tkz) {
        super(tkz);
    }
    
    public void setXFactory(XFact xf) {
        xFact = xf;
    }
    
    public ITokVisitor makeVisitor() {
        _initializer.apply(null);
        return new TokenA.ITokAVisitor() {
            public Object tokACase(TokenA host, Object param) {
                return new A(host, (AX)nextToken().execute(_parseX, param));
            }
            
            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Expect " + TokenA.Singleton + " but get " + host);
            }
        };    
    }
    
    public ITokVisitor makeChainedVisitor(ITokVisitor succ) {
        _initializer.apply(null);
        return new TokenA.AChainVis(succ) {
            public Object tokACase(TokenA host, Object param) {
                return new A(host, (AX)nextToken().execute(_parseX, param));
            }
        };     }
}

