package parser;

import rules.*;
import tokens.*;

public class CFact extends ATVFactory {
    
    public CFact(ITokenizer tkz) {
        super(tkz);
    }
    
    public ITokVisitor makeVisitor() {
        return new TokenC.ITokCVisitor() {
            public Object tokCCase(TokenC host, Object param) {
                return new C(host);
            }
            
            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Expect " + TokenC.Singleton + " but get " + host);
            }
        };
    }
    
    public ITokVisitor makeChainedVisitor(ITokVisitor succ) {
        return new TokenC.AChainVis(succ) {
            public Object tokCCase(TokenC host, Object param) {
                return new C(host);
            }
        };
    }
}

