package parser;

import tokens.*;

public class XFact extends ATVFactory {
    private AFact aFact;
    private CFact cFact;
    
    public XFact(ITokenizer tkz, AFact af, CFact cf) {
        super(tkz);
        aFact = af;
        cFact = cf;
    }
    
    public ITokVisitor makeVisitor() {
        return aFact.makeChainedVisitor(cFact.makeVisitor());
    }
    

    public ITokVisitor makeChainedVisitor(ITokVisitor succ) {
        return aFact.makeChainedVisitor(cFact.makeChainedVisitor(succ));
    }
}

