package tokens;

/**
 * Abstract factory for a token visitor.
 */
public abstract class ATVFactory implements ITVFactory {
    /**
     * Tokenizer.
     */
    private ITokenizer _tokenizer;

    /**
     * Constructor for the abstract factory.
     *
     * @param tkz tokenizer to use
     */
    public ATVFactory(ITokenizer tkz) {
        _tokenizer = tkz;
    }

    /**
     * Return the next token.
     *
     * @return next token
     */
    protected final AToken nextToken() {
        AToken t = _tokenizer.getNextToken();
        //System.out.println("current token: " + t);
        return t;
    }

    /**
     * Put the last token back into the tokenizer.
     */
    protected final void putBackToken() {
        // DXN: add putBack for the empty factory to put back token.
        _tokenizer.putBack();
    }
}

