package tokens;

/**
 * Extract and return an appropriate AToken from some given source.
 */
public abstract interface ITokenizer {
    /**
     * Return the next token.
     */
    public abstract AToken getNextToken();

    /**
     * Put the previously consumed token back into the token stream. Can only put back one token.
     */
    public abstract void putBack();
}
