package tokens;

/**
 * C token class.
 */
public class TokenC extends AToken {

    public static interface ITokCVisitor extends ITokVisitor {
        public Object tokCCase(TokenC host, Object param);
    }

    public static abstract class AChainVis implements ITokCVisitor {

        private ITokVisitor _successor;

        protected AChainVis(ITokVisitor successor) {
            _successor = successor;
        }

        public Object defaultCase(AToken host, Object param) {
            return host.execute(_successor, param);
        }
    }

    public final static TokenC Singleton = new TokenC();
    private TokenC() {
        super("c");
    }

    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof ITokCVisitor) ?
               ((ITokCVisitor) algo).tokCCase(this, param) :
               algo.defaultCase(this, param);
    }
}

