package treeNAlgo;
import treeN.*;

/**
 * Converts a 2-3-4 tree to a Red-Black tree.
 * @author DXN
 */
public class From234ToRedBlack implements ITreeNAlgo {
    public static final From234ToRedBlack Singleton = new From234ToRedBlack();
    private From234ToRedBlack() {
    }
    
    /**
     * Perform recursively the following operation from the bottom of the tree
     * up towards the root:
     * Splits a 3 children node into a 2 children node ( like a binary tree)
     * whose root contains a Black decorated object, and whose left subtree
     * has a root that contains a Red decorated object.
     * 
     * Splits a 4 children node into a 2 children node ( like a binary tree)
     * whose root contains a Black decorated object, and whose left and right
     * subtrees with Red decorated object roots.
     * 
     */
    public Object caseAt(int i, TreeN host, Object... nu) {
        switch(i) {
            case 0: {
                return host;
            }
            case 1: {
                // This is the case with 1 data and 2 children subtrees.
                // Recurse down the left and right subtrees
                host.getChild(0).execute(this);
                host.getChild(1).execute(this);
                host.setDat(0, new Black(host.getDat(0)));
                return host;
            }
            case 2: {
                // This is the case with 2 data and 3 children subtrees.
                // Recurse down the subtrees and split up the root node
                // as specified.
                host.getChild(0).execute(this);
                host.getChild(1).execute(this);
                host.getChild(2).execute(this);
                host.setDat(0, new Red(host.getDat(0)));
                host.setDat(1, new Black(host.getDat(1)));
                return host.splitUpAt(1);
            }
            case 3: {
                // This is the case with 3 data and 4 children subtrees.
                // Recurse down the subtrees and split up the root node
                // as specified.
                host.getChild(0).execute(this);
                host.getChild(1).execute(this);
                host.getChild(2).execute(this);
                host.getChild(3).execute(this);
                host.setDat(0, new Red(host.getDat(0)));
                host.setDat(1, new Black(host.getDat(1)));
                host.setDat(2, new Red(host.getDat(2)));
                return host.splitUpAt(1);
            }            
            default: {
                return host;
            }
        }
    }
}