package treeNAlgo;
import treeN.*;

/**
 * Serves as a helper visitor in the process of transforming a red-black tree
 * to a standard (unmarked) 2-3-4 tree.
 * The RBObject host is the root data of the given child TreeN of a given 
 * red-black TreeN.
 * Only when this host is Red that the child tree spliced to its given parent
 * TreeN at a given index in order to transform the parent red-black tree
 * to a 2-3-4 tree whose root should contain only the (unmarked) raw data. 
 */
class CollapseRed implements IRBVisitor {
    public static final CollapseRed Singleton = new CollapseRed();
    private CollapseRed() {
    }
    
    /**
     * Splices the given child tree to the given parent tree at the given
     * index and remove the red marker from the host.
     * @param r the root data of the child TreeN inp[1].
     * @param inp inp[0] is the index to be spliced at,
     * in[1] is the child TreeN to be spliced into inp[2],
     * inp[2] is the parent red-black TreeN.
     * @return TreeN inp[2].
     */
    public Object redCase(Red r, Object... inp) {
        TreeN child = (TreeN)inp[1];
        child.setDat(0, r.getObject());
        return ((TreeN)inp[2]).spliceAt((Integer)inp[0], child);
    }
    
    /**
     * Removes the  black marker from the host.
     * @param r the root data of the child TreeN inp[1].
     * @param inp inp[0] is the index to be spliced at,
     * in[1] is the child TreeN to be spliced into inp[2],
     * inp[2] is the parent red-black TreeN.
     * @return TreeN inp[2].
     */
    public Object blackCase(Black b, Object... inp) {
        TreeN child = (TreeN)inp[1];
        child.setDat(0, b.getObject());
        return inp[2];
    }
}
    
/**
 * Serves as a helper visitor in the process of transforming a red-black tree
 * to a standard (unmarked) 2-3-4 tree.
 * Tries to collapse the host tree to its parent tree at a given index.
 * Only trees whose root nodes are red are to be collapsed with their parents.
 * FOR STUDENT TO COMPLETE
 */
class CollapseAll implements ITreeNAlgo {
    public static final CollapseAll Singleton = new CollapseAll();
    private CollapseAll() {
    }
    
    /**
     * Only collapses the red host tree to the given parent tree at the given 
     * index, and recursively traverses down the right and left subtrees to perform 
     * the same operation.
     * @param inp inp[0] the index for where to splice to the parent,
     * inp[1] the parent tree.
     * @return this.
     */
    public Object caseAt(int i, TreeN host, Object... inp) {
        switch (i) {
            case 0: {
                return host;
            }
            case 1: {
                // Hint: since the host can mutate, hold on to its left and right
                // subtree before trying to collapse the host to its parent.
                TreeN left = host.getChild(0);
                TreeN right = host.getChild(1);
                ((ARBObject)host.getDat(0)).execute(CollapseRed.Singleton, inp[0], host, inp[1]); 
                right.execute(this, 1, host);
               left.execute(this, 0, host);                
                return host;
            }
            default: {
                return host;
            }
        }
    }    
}
    
/**
 * Converts a Red-Black tree to a 2-3-4 tree.
 * The host is assumed to be a red-black tree whose data nodes contain RBObject.
 * The root node is a black node.
 * 
 * FOR STUDENT TO COMPLETE
 * @author DXN
 */
public class RBto234 implements ITreeNAlgo {
    public static final RBto234 Singleton = new RBto234();
    private RBto234() {
    }
    
    /**
     * Converts this red-black to a corresponding 2-3-4 tree by collapsing the trees 
     * with red nodes with their (black) parents.
     * FOR STUDENT TO COMPLETE
     */
    public Object caseAt(int i, TreeN host, Object... nu) {
        switch(i) {
            case 0: {
                return host;
            }
            case 1: {
                // Hint: since the host can mutate, unwrap the root data and hold on 
                // to the left and right subtree before trying to collapse them to the host.
                host.setDat(0, ((ARBObject)host.getDat(0)).getObject());
                TreeN left = host.getChild(0);
                TreeN right = host.getChild(1);
                right.execute(CollapseAll.Singleton, 1, host);
                left.execute(CollapseAll.Singleton, 0, host);                
                return host;
            }            
            default: {
                return host;
            }
        }
    }
}           
