package kochController;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;

/**
 * @dependency kochController.KochController instantiates
 */
public class KochApplet extends JApplet
{
  boolean isStandalone = false;
  JButton runBrn = new JButton();
  /**Get a parameter value*/
  public String getParameter(String key, String def)
  {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  /**Construct the applet*/
  public KochApplet()
  {
  }
  /**Initialize the applet*/
  public void init()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }
  /**Component initialization*/
  private void jbInit() throws Exception
  {
    runBrn.setFont(new java.awt.Font("Dialog", 0, 24));
    runBrn.setText("Run Koch Curve Application");
    runBrn.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        runBrn_actionPerformed(e);
      }
    });
    this.setSize(new Dimension(354, 80));
    this.getContentPane().add(runBrn, BorderLayout.CENTER);
  }
  /**Get Applet information*/
  public String getAppletInfo()
  {
    return "Applet Information";
  }
  /**Get parameter info*/
  public String[][] getParameterInfo()
  {
    return null;
  }

  //static initializer for setting look & feel
  static
  {
    try
    {
      //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      //UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    }
    catch(Exception e)
    {
    }
  }

  void runBrn_actionPerformed(ActionEvent e)
  {
    (new KochController()).makeKoch(WindowConstants.HIDE_ON_CLOSE);

  }
}