package kochModel;
import lrs.*;
import java.awt.*;

import kochModel.*;
//import kochModel.algos.*;
import fp.*;

/**
 * The non-base case state of the Koch curve.   This state is just a wrapper around a list of Koch curves that supplies the required
 * paint and grow methods.   These methods are recursively applied to the  list of Koch curves held.
 */
class DrawManyState extends AKochState
{
  /**
   * The IAlgo to use when painting the list of Koch curves.
   */
//  private static final IAlgo paintAlgo = new IAlgo() {
//    public Object emptyCase(LRStruct host, Object... param) {
//      return (null);
//    }
//    
//    public Object nonEmptyCase(LRStruct host, Object... param) {
//      ((Koch)host.getFirst()).paint((Graphics)param[0]);
//      return (host.getRest().execute(this,param));
//    }
//  };
  /**
   * The IAlgo to use when growing the list of Koch curves.
   */
//  private static final IAlgo growAlgo = new IAlgo() {
//    public Object emptyCase(LRStruct host, Object... param) {
//      return (null);
//    }
//    
//    public Object nonEmptyCase(LRStruct host, Object... param) {
//      ((Koch)host.getFirst()).grow((IFactory)param[0]);
//      return (host.getRest().execute(this,param));
//    }
//  };
  
  
//  IAlgo countAlgo = new IAlgo() {
//    public Object emptyCase(LRStruct host, Object... param) {
//      return 0;
//    }
//    public Object nonEmptyCase(LRStruct host, Object... param) {
//      return ((Koch)host.getFirst()).count() + ((Integer)host.getRest().execute(this));
//    }
//  };
  /**
   * The list of Koch curves.
   */
  private LRStruct kochList = new LRStruct();
  
  /**
   * Constructor for this state, not publicly accessible.
   * All this constructor does is to initialize the list of Kochs being held.
   * @param kochList A list of  Koch curves to attach as those being held.
   */
  DrawManyState(LRStruct kochList)
  {
    
    this.kochList = kochList;
  }
  
  /**
   * Executes the internally held GrowAlgorithm object on its list of Koch curves, using the supplied factory object.
   * @param context The Koch object which is the present context.
   * @param factory The factory to be used when the base case executes.   This parameter is simply passed on in the recursion call.
   */
//  void grow(IFactory factory, Koch context)
//  {
//    kochList.execute(growAlgo,factory);
//  }
  
  /**
   * This method executes the internally held PaintAlgo painting algorithm object on the list of Koch curves.   The supplied Graphics
   * parameter "g" is passed on to be used by the base case.
   * @param g The Graphics object upon which to draw.
   * @param context The Koch object which is the context in which this method is running.
   */
//  void paint(Graphics g, Koch context)
//  {
//    kochList.execute(paintAlgo,g);
//  }
  
  /**
   * @param host
   * @return
   */
//  int count(Koch host)
//  {
//    return ((Integer) kochList.execute(countAlgo)).intValue();
//  }
  
  public Object execute(Koch host, IKochVisitor algo, Object...param) {
    return algo.inductCase(host, param);
  }
  
 public <R,P> Object fold(final Koch host, final IFoldAlgo<Koch,R,P> algo, R base, final P... param) {
   return kochList.execute(new IAlgo() {
    public Object emptyCase(LRStruct host, Object... rr) {
      return rr[0];
    }
    
    public Object nonEmptyCase(LRStruct host, Object... rr) {
      return algo.apply((Koch)host.getFirst(), (R)(host.getRest().execute(this,rr)), param);
    }
  
   }, base);
 }
  
}

