
package kochModel;

import kochModel.factory.*;
import kochModel.visitor.*;
import java.awt.*;
import java.awt.geom.Point2D.Double;

public class KochModel
{
  Double ptA = new Double(200, 500);
  Double ptB = new Double(650, 500);
  
  private IFactory aFactory = new KochCurveFactory();
  private Koch koch = aFactory.makeOne(ptA, ptB);
  
  public void grow() {
    //koch.grow(aFactory);
    koch.execute(GrowVisitor.Singleton, aFactory);
  }
  
  public void paint(Graphics g) {
    //koch.paint(g);
//    koch.execute(PaintNoParentVisitor.Singleton, g);
    koch.execute(paintAlgo, g);
  }
  
  public void reset() {
    koch = aFactory.makeOne(ptA, ptB);
  }
  
  
  public void changeFactoryTo(String s) {
    try {
      java.lang.reflect.Constructor c =  Class.forName(s).getConstructors()[0];
      Object [][] args = new Object[][]{new Object[]{}, new Object[]{aFactory}};
      aFactory = (IFactory) c.newInstance(args[c.getParameterTypes().length]);
    }
    catch(Exception ex) {
      System.out.println(ex);
      
    }
  }
  
  IKochVisitor paintAlgo = PaintNoParentVisitor.Singleton;
  
  public void changePaintAlgoTo(String s) {
    try {
      paintAlgo = (IKochVisitor) Class.forName(s).getDeclaredField("Singleton").get(null);
    }
    catch(Exception ex) {
      System.out.println(ex);     
    }
  }
  
  
  
  public int count() {
    return (Integer) koch.execute(CountVisitor.Singleton);
//return koch.count();
  }
}
