package kochModel.factory;

import java.awt.geom.Point2D;

/**
 * The factory to produce the standard Koch curve.
 *
 */
public class KochCurveFactory extends CurveFactory
{
	/**
	 * Defines the prototype points needed (without endpoints) for the standard Koch curve.
	 * *
	 * @SBGen Constructor
	 */
	public KochCurveFactory()
	{
		getProtoList().insertFront(new Point2D.Double(2.0/3.0,0.0));
		getProtoList().insertFront(new Point2D.Double(0.5,-1.0/3.0*Math.sqrt(3.0)/2.0));
		getProtoList().insertFront(new Point2D.Double(1.0/3.0,0.0));
	}
 //0.288675
}

