package kochModel.visitor;

import fp.*;
import kochModel.*;
import java.awt.Graphics;

public class PaintParentVisitor implements IKochVisitor, IFoldAlgo<Koch, Object, Graphics> {
  
  public static final PaintParentVisitor Singleton = new PaintParentVisitor();
  
  private PaintParentVisitor() {}
  
  public Object baseCase(Koch host, Object... g) {
    paint(host, (Graphics)g[0]);
    return null;
  }
  
  public Object inductCase(Koch host, Object... g) {
    paint(host, (Graphics)g[0]);
    return host.fold(this, null, (Graphics)g[0]);
  }
  
  public Object apply( Koch host, Object base, Graphics... g) {
    return host.execute(this, g[0]);
  }

  private void paint(Koch host, Graphics g) {
        g.drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
                          (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));

  }
}