package kochView;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import kochModel.*;
//import kochModel.algos.*;

//import LRStructure.*;
import kochModel.*;
import kochModel.factory.*;

public class KochFrame extends JFrame
{
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel jPanel1 = new JPanel();
  JButton growBtn = new JButton();

  JButton resetBtn = new JButton();


  boolean isApplet = false;
  JComboBox factoriesCBx = new JComboBox();
  JComboBox paintAlgosCBx = new JComboBox();

  IPaintAdapter paintAdapter;
  IControlAdapter controlAdapter;
  JLabel countLbl = new JLabel();


  //Construct the frame
  public KochFrame(IPaintAdapter paintAdapter, IControlAdapter controlAdapter, int closeOp) {
    setDefaultCloseOperation(closeOp);

    this.paintAdapter = paintAdapter;
    this.controlAdapter = controlAdapter;
    this.isApplet=isApplet;

    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
    factoriesCBx.addItem("kochModel.factory.KochCurveFactory");
    factoriesCBx.addItem("kochModel.factory.MyCurveFactory");
    factoriesCBx.addItem("kochModel.factory.SnowflakeFactory");
    factoriesCBx.addItem("kochModel.factory.RectangleSnowflakeFactory");
    factoriesCBx.addItem("kochModel.factory.KochFractalFactory");
    factoriesCBx.addItem("kochModel.factory.MyFractalFactory");
    factoriesCBx.addItem("kochModel.factory.Tree1FractalFactory");
    factoriesCBx.addItem("kochModel.factory.Tree2FractalFactory");
    factoriesCBx.addItem("kochModel.factory.Tree1_2FractalFactory");
    factoriesCBx.addItem("kochModel.factory.BoxFractalFactory");
    factoriesCBx.addItem("kochModel.factory.KochBoxFractalFactory");
    factoriesCBx.addItem("kochModel.factory.SnowflakeFractalFactory");
    factoriesCBx.addItem("kochModel.factory.RectangleSnowFlakeFractalFactory");
    factoriesCBx.setSelectedIndex(0);

    paintAlgosCBx.addItem("kochModel.visitor.PaintNoParentVisitor");
    paintAlgosCBx.addItem("kochModel.visitor.PaintParentVisitor");
    paintAlgosCBx.addItem("kochModel.visitor.PaintColorVisitor");
    paintAlgosCBx.setSelectedIndex(0);
    
    // Needed because frame doesn't repaint on resize otherwise
    addComponentListener(new ComponentAdapter() {
      public void componentResized(ComponentEvent e) {
        repaint();
      }
    });
  }

  //Component initialization
  private void jbInit() throws Exception
  {
    this.getContentPane().setLayout(borderLayout1);
    this.setSize(new Dimension(971, 743));
    this.setTitle("Frame Title");
    growBtn.setToolTipText("Grow using currently selected factory,");
    growBtn.setText("Grow!");
    growBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        growBtn_actionPerformed(e);
      }
    });
    resetBtn.setToolTipText("Reset back to base case using currently selected factgory..");
    resetBtn.setText("Reset");
    resetBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        resetBtn_actionPerformed(e);
      }
    });
    
    factoriesCBx.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        factoriesCBx_actionPerformed(e);
      }
    });
    
    paintAlgosCBx.addActionListener(new java.awt.event.ActionListener()
    {
      public void actionPerformed(ActionEvent e)
      {
        paintAlgosCBx_actionPerformed(e);
      }
    });
    this.getContentPane().add(jPanel1, BorderLayout.NORTH);
    jPanel1.add(growBtn, null);
    jPanel1.add(resetBtn, null);
    jPanel1.add(factoriesCBx, null);
    jPanel1.add(countLbl, null);
    jPanel1.add(factoriesCBx, null);
    jPanel1.add(paintAlgosCBx, null);
    resetBtn_actionPerformed(null);   // reset the system
  }

  //Overridden so we can exit on System Close
  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if(!isApplet && e.getID() == WindowEvent.WINDOW_CLOSING)
    {
      System.exit(0);
    }
  }


  void growBtn_actionPerformed(ActionEvent e)
  {
      countLbl.setText("# line segs = "+controlAdapter.grow());
      repaint();
  }

  public void paint(Graphics g)
  {
    super.paint(g);
    g.setColor(Color.blue);
    paintAdapter.paint(g);
  }

  void resetBtn_actionPerformed(ActionEvent e)
  {
    countLbl.setText("# line segs = "+controlAdapter.reset());
    repaint();
  }


  void factoriesCBx_actionPerformed(ActionEvent e) {
     controlAdapter.changeFactoryTo((String)factoriesCBx.getItemAt(factoriesCBx.getSelectedIndex()));
  }

  void paintAlgosCBx_actionPerformed(ActionEvent e) {
     controlAdapter.changePaintAlgoTo((String)paintAlgosCBx.getItemAt(paintAlgosCBx.getSelectedIndex()));
     repaint();
  }
}
