package lrs.visitor;
import lrs.*;

public class Advance1 implements IAlgo {
    public final static Advance1 Singleton = new Advance1 ();

    private Advance1() {
    }

    /**
    * We know the input is a potential split point and now we are at the end of
    * the original list.  So we split right here at the split point.
    * @param host
    * @param accSplit
    * @return
    */
    public Object emptyCase(LRStruct host, Object accSplit) {
        LRStruct splitPoint = (LRStruct)accSplit;
        LRStruct tailHalf = new LRStruct ();
        tailHalf.execute (Becomes.Singleton, splitPoint);
        splitPoint.execute (Becomes.Singleton, new LRStruct ());
        return tailHalf;
    }

    /**
    *  Asks the host's tail to split passing input as a potential "split point".
    * @param host
    * @param accSplit  a LRStruct.
    * @return
    */
    public Object nonEmptyCase(LRStruct host, Object accSplit) {
        return host.getRest().execute(Advance0.Singleton, accSplit);
    }
}

