/*
 * $Id: InsertInDecreasingOrder.java,v 1.3 2003/02/28 17:51:44 alc Exp $
 */
package lrs.visitor;

import lrs.*;

/*
 * Implements insert in decreasing order on an LRStruct.  The objects
 * contained within the LRStruct must implement Comparable.  Failure
 * to do so will result in an exception at run-time.
 */
public class InsertInDecreasingOrder implements IAlgo {
   public static final InsertInDecreasingOrder Singleton =
       new InsertInDecreasingOrder();
   private InsertInDecreasingOrder() {
   }

   /**
   * Simply inserts the given parameter n at the front.
   * @param host an empty LRStruct.
   * @param n a Comparable to be inserted in decreasing order into host.
   * @return LRStruct
   */
   public Object emptyCase(LRStruct host, Object n) {
       return host.insertFront(n);
   }

   /**
   * Based on the comparison between first and n,
   * inserts at the front or recurs!
   * @param host a non-empty LRStruct.
   * @param n a Comparable to be inserted in decreasing order into host.
   * @return LRStruct
   */
   public Object nonEmptyCase(LRStruct host, Object n) {
       Comparable first = (Comparable)host.getFirst();
       /*
	* Think of the following expression as first "-" n <= 0
	*/
       if (first.compareTo(n) <= 0)
	   return host.insertFront(n);			// first <= n
       else
	   return host.getRest().execute(this, n);	// first > n
   }
}
