package lrs.visitor;
import lrs.*;
import java.util.*;

public class InsertInOrder implements IAlgo {

    private Comparator _order;

    public InsertInOrder(Comparator ord) {
        _order = ord;
    }

    /**
     * Simply inserts the given parameter n at the front.
     * @param host an empty LRStruct.
     * @param N an Object to be inserted in order into host,
     *   based on the given Comparator.
     * @return LRStruct
     */
    public Object emptyCase(LRStruct host, Object N) {
        return host.insertFront(N);
    }

    /**
     * Based on the comparison between first and N,
     * inserts at the front or recurs!
     * @param host a non-empty LRStruct.
     * @param N an Object to be inserted in order into host,
     *   based on the given Comparator.
     * @return LRStruct
     */
    public Object nonEmptyCase(LRStruct host, Object N) {
        if (_order.compare(N, host.getFirst()) < 0) {
            return host.insertFront(N);
        }
        else {
            return host.getRest().execute(this, N);
        }
    }
}

