package parser;

/**
 * Left parenthesis token class.
 */
public class LeftPToken extends AToken {
    /**
     * Interface for a visitor to visit a left parenthesis token.
     */
    public static interface ILeftPVisitor extends ITokVisitor {
        /**
         * Case for a left parenthesis token.
         *
         * @param host  left parenthesis token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object leftPCase(LeftPToken host, Object param);
    }

    /**
     * Abstract class for a chained visitor to visit a plus token. In all non-plus cases, the successor is called.
     */
    public static abstract class AChainVis implements ILeftPVisitor {
        /**
         * Successor.
         */
        private ITokVisitor _successor;

        /**
         * Constructor.
         *
         * @param successor visitor to serve as successor in the chain of responsibility.
         */
        protected AChainVis(ITokVisitor successor) {
            _successor = successor;
        }

        /**
         * Continue in the chain of responsibility.
         *
         * @param host  token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object defaultCase(AToken host, Object param) {
            return host.execute(_successor, param);
        }
    }

    /**
     * Singleton instance.
     */
    public final static LeftPToken Singleton = new LeftPToken();

    /**
     * Private singleton constructor.
     */
    private LeftPToken() {
        super("(");
    }

    /**
     * Execute the left parenthesis case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof ILeftPVisitor) ?
               ((ILeftPVisitor) algo).leftPCase(this, param) :
               algo.defaultCase(this, param);
    }
}

