package parser;

/**
 * Multiply token class.
 */
public class MultToken extends AToken {
    /**
     * Interface for a visitor to visit a multiply token.
     */
    public static interface IMultVisitor extends ITokVisitor {
        /**
         * Case for a mult token.
         *
         * @param host  mult token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object multCase(MultToken host, Object param);
    }

    /**
     * Abstract class for a chained visitor to visit a number token. In all non-plus cases, the successor is called.
     */
    public static abstract class AChainVis implements IMultVisitor {
        /**
         * Successor.
         */
        private ITokVisitor _successor;

        /**
         * Constructor.
         *
         * @param successor visitor to serve as successor in the chain of responsibility.
         */
        protected AChainVis(ITokVisitor successor) {
            _successor = successor;
        }

        /**
         * Continue in the chain of responsibility.
         *
         * @param host  token
         * @param param visitor-specific parameter
         * @return visitor-specific return value
         */
        public Object defaultCase(AToken host, Object param) {
            return host.execute(_successor, param);
        }
    }

    /**
     * Singleton instance.
     */
    public final static MultToken Singleton = new MultToken();

    /**
     * Private singleton constructor.
     */
    private MultToken() {
        super("*");
    }

    /**
     * Execute the mult case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof IMultVisitor) ?
               ((IMultVisitor) algo).multCase(this, param) :
               algo.defaultCase(this, param);
    }
}

