package parser;

/**
 * Grammar non-terminal -- T ::= F T1
 */
public class T implements S {
    /**
     * F object.
     */
    private F _f;

    /**
     * T1 object.
     */
    private T1 _t1;

    /**
     * Constructor for the T grammar non-terminal.
     *
     * @param f  F object
     * @param t1 T1 object
     */
    public T(F f, T1 t1) {
        _f = f;
        _t1 = t1;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _f.toString() + _t1.toString();
    }
}

