/*
 * Decompiled with CFR 0.152.
 */
package infixModel;

import infixModel.ACalcState;
import infixModel.AccumState;
import infixModel.IBinOp;
import infixModel.InfixCalc;
import infixModel.PointState;
import infixModel.StartState;

class CompState
extends ACalcState {
    public static final CompState Singleton = new CompState();

    private CompState() {
    }

    public void enterDigit(InfixCalc calc, char c) {
        calc.setDisplay("" + c);
        if ('0' != c) {
            calc.setCurState(AccumState.Singleton);
        } else {
            calc.setCurState(StartState.Singleton);
        }
    }

    public void enterOp(InfixCalc calc, IBinOp op) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setPendingOp(op);
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        }
    }

    public void enterEqual(InfixCalc calc) {
        calc.setDisplay("Syntax Error!");
        calc.setCurState(ErrorState);
    }

    public void enterPoint(InfixCalc calc) {
        calc.setDisplay("0.");
        calc.setCurState(PointState.Singleton);
    }
}

