/*
 * Decompiled with CFR 0.152.
 */
package infixView;

import infixModel.AddOp;
import infixModel.IBinOp;
import infixModel.InfixCalc;
import infixModel.MulOp;
import infixView.AFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import javax.swing.JButton;
import javax.swing.JTextField;

public class InfixGUI
extends AFrame {
    private InfixCalc _calc;
    private JTextField _display;

    public InfixGUI() {
        super("Cheap Calculator");
    }

    public InfixGUI(WindowAdapter windowCloser) {
        super("Cheap Calculator", windowCloser);
    }

    protected void initialize() {
        JButton zeroJButton = new JButton("0");
        JButton threeJButton = new JButton("3");
        JButton fourJButton = new JButton("4");
        JButton fiveJButton = new JButton("5");
        JButton sixJButton = new JButton("6");
        JButton sevenJButton = new JButton("7");
        JButton eightJButton = new JButton("8");
        JButton nineJButton = new JButton("9");
        JButton pointJButton = new JButton(".");
        JButton equalsJButton = new JButton("=");
        JButton plusJButton = new JButton("+");
        JButton mulJButton = new JButton("x");
        JButton clearJButton = new JButton("C");
        this._calc = new InfixCalc();
        this._display = new JTextField("0", 12);
        Container cp = this.getContentPane();
        cp.setLayout(new FlowLayout());
        cp.add(this._display);
        this._display.setBackground(Color.white);
        this._display.setEnabled(false);
        cp.add(zeroJButton);
        zeroJButton.addActionListener(new DigitListener('0'));
        cp.add(threeJButton);
        threeJButton.addActionListener(new DigitListener('3'));
        cp.add(fourJButton);
        fourJButton.addActionListener(new DigitListener('4'));
        cp.add(fiveJButton);
        fiveJButton.addActionListener(new DigitListener('5'));
        cp.add(sixJButton);
        sixJButton.addActionListener(new DigitListener('6'));
        cp.add(sevenJButton);
        sevenJButton.addActionListener(new DigitListener('7'));
        cp.add(eightJButton);
        eightJButton.addActionListener(new DigitListener('8'));
        cp.add(nineJButton);
        nineJButton.addActionListener(new DigitListener('9'));
        cp.add(pointJButton);
        pointJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfixGUI.this._display.setText(InfixGUI.this._calc.enterPoint());
            }
        });
        cp.add(plusJButton);
        plusJButton.addActionListener(new OpListener(AddOp.Singleton));
        cp.add(mulJButton);
        mulJButton.addActionListener(new OpListener(MulOp.Singleton));
        cp.add(equalsJButton);
        equalsJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfixGUI.this._display.setText(InfixGUI.this._calc.enterEqual());
            }
        });
        cp.add(clearJButton);
        clearJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfixGUI.this._display.setText(InfixGUI.this._calc.clear());
            }
        });
        cp.setBackground(Color.BLUE);
        this.setSize(400, 200);
        this.setVisible(true);
    }

    private class OpListener
    implements ActionListener {
        private IBinOp op;

        OpListener(IBinOp o) {
            this.op = o;
        }

        public void actionPerformed(ActionEvent e) {
            InfixGUI.this._display.setText(InfixGUI.this._calc.enterOp(this.op));
        }
    }

    private class DigitListener
    implements ActionListener {
        private char digit;

        DigitListener(char c) {
            this.digit = c;
        }

        public void actionPerformed(ActionEvent e) {
            InfixGUI.this._display.setText(InfixGUI.this._calc.enterDigit(this.digit));
        }
    }
}

