/*
 * Decompiled with CFR 0.152.
 */
package infixModel;

import infixModel.ACalcState;
import infixModel.CompState;
import infixModel.IBinOp;
import infixModel.InfixCalc;
import infixModel.PointState;
import infixModel.StartState;

class AccumState
extends ACalcState {
    static final AccumState Singleton = new AccumState();

    private AccumState() {
    }

    public void enterDigit(InfixCalc calc, char c) {
        calc.setDisplay(calc.getDisplay() + c);
    }

    public void enterOp(InfixCalc calc, IBinOp op) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setPendingOp(op);
            calc.setCurState(CompState.Singleton);
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        }
    }

    public void enterEqual(InfixCalc calc) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setNoOp();
            calc.setCurState(StartState.Singleton);
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        }
    }

    public void enterPoint(InfixCalc calc) {
        calc.setDisplay(calc.getDisplay() + ".");
        calc.setCurState(PointState.Singleton);
    }
}

