/*
 * Decompiled with CFR 0.152.
 */
package infixModel;

import infixModel.ACalcState;
import infixModel.AccumState;
import infixModel.CompState;
import infixModel.IBinOp;
import infixModel.InfixCalc;
import infixModel.PointState;

class StartState
extends ACalcState {
    public static final StartState Singleton = new StartState();

    private StartState() {
    }

    public void enterDigit(InfixCalc calc, char c) {
        calc.setDisplay("" + c);
        if ('0' != c) {
            calc.setCurState(AccumState.Singleton);
        }
    }

    public void enterOp(InfixCalc calc, IBinOp op) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setPendingOp(op);
            calc.setCurState(CompState.Singleton);
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        }
    }

    public void enterEqual(InfixCalc calc) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setNoOp();
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        }
    }

    public void enterPoint(InfixCalc calc) {
        calc.setDisplay("0.");
        calc.setCurState(PointState.Singleton);
    }
}

