package demo;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Add SwingUtilities.InvokeLater method in main.
 * @revised by DXN 04/07/2008
 */
public class AppLauncher extends JApplet {
    
    public void init() {
        Container cp = getContentPane();
        JButton btn = new JButton("Click here to start demo...");
        btn.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                makeDemo(new WindowAdapter(){});
            }
        });
        cp.add(btn);
    }
    
    /**
     * Main function to start of the program.  No input arguments required.
     * Simply instantiates the GUI.
     */
    public static void main(String [] args) {
//        makeDemo(new WindowAdapter() {
//            public void windowClosing(java.awt.event.WindowEvent e) {
//                System.exit(0);
//            }
//        });
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                makeDemo(new WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });            
            }
        });       }
    
    private static void makeDemo(WindowAdapter windowCloser) {
        new infixView.InfixGUI(windowCloser);
    }
}