
package infixModel;

/**
 * Represents the abstract state of the calculator (the context)
 */
abstract class ACalcState {
    /**
     * An error state object for general use
     * A null object, does nothing.
     */
    final static ACalcState ErrorState = new ACalcState() { // state 3 is error state: null-object pattern, does nothing!
        public void enterDigit(InfixCalc calc, char c) {
        }
        
        public void enterOp(InfixCalc calc, IBinOp op) {
        }
        
        public void enterEqual(InfixCalc calc) {
        }
        
        public void enterPoint(InfixCalc calc) {
        }
    };
    
    /**
     * Appends c to the string of digit collected so far.
     * @param calc The calculator model (context)
     * @param c The digit being entered
     */
    public abstract void enterDigit(InfixCalc calc, char c);
    
    /**
     * Performs the pending operation, and set op as the next pending operation
     * on whatever is computed so far to the operand that will be entered next.
     * @param calc The calculator model (context)
     * @param op The new pending operation
     */
    public abstract void enterOp(InfixCalc calc, IBinOp op);
    
    /**
     * Computes the pending operation.
     * @param calc The calculator model (context)
     */
    public abstract void enterEqual(InfixCalc calc);
    
    /**
     * Enters a decimal point.
     * @param calc The calculator model (context)
     */
    public abstract void enterPoint(InfixCalc calc);
}

