
package infixModel;

/**
 * State where the calculator has accumulated digits of a number into the display.
 */
class AccumState extends ACalcState {
    /**
     * Singleton instance
     */
    static final AccumState Singleton = new AccumState();
    /**
     * Hidden constructor
     */
    private AccumState() {
    }
    
    /**
     * Appends c to the string of digit collected so far.
     * @param calc The calculator model (context)
     * @param c The digit being entered
     */
    public void enterDigit(InfixCalc calc, char c) {
        //        System.out.println("Accumulate State: enter character " + c);
        calc.setDisplay(calc.getDisplay() + c);
    }
    
    /**
     * Performs the pending operation, and set op as the next pending operation
     * on whatever is computed so far to the operand that will be entered next.
     * Go to error if the number in the display does not parse properly into a floating point number.
     * @param calc The calculator model (context)
     * @param op The new pending operation
     */
    public void enterOp(InfixCalc calc, IBinOp op) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setPendingOp(op);
            calc.setCurState(CompState.Singleton);
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        };
        
    }
    
    /**
     * Computes the pending operation and updates the pending op to no-op
     * since there is no more operations to perform.
     * @param calc The calculator model (context)
     */
    public void enterEqual(InfixCalc calc) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setNoOp();
            calc.setCurState(StartState.Singleton);        
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        };
    }    
    
    /**
     * Enter a decimal point.  Go to point state.
     * @param calc The calculator model (context)
     */
    public void enterPoint(InfixCalc calc) {
        calc.setDisplay(calc.getDisplay() + ".");
        calc.setCurState(PointState.Singleton);
    }
}

