
package infixModel;

/**
 * State where the calculator has computed a result
 */
class CompState extends ACalcState {
    /**
     * Singleton instance
     */
    public static final CompState Singleton = new CompState();
    /**
     * Hidden constructor
     */
    private CompState() {
    }
    
    /**
     * Appends c to the string of digit collected so far if not zero.
     * If zero, then set display to "0" and return to start state.
     * @param calc The calculator model (context)
     * @param c The digit being entered
     */
    public void enterDigit(InfixCalc calc, char c) {
        //        System.out.println("Compute State: enter character " + c);
        calc.setDisplay("" + c);
        if ('0' != c) {
//            calc.setDisplay("" + c);
            calc.setCurState(AccumState.Singleton);
        }
        else {
//            calc.setDisplay("0");
            calc.setCurState(StartState.Singleton);
        }
    }
    
    /**
     * Performs the pending operation, and set op as the next pending operation
     * on whatever is computed so far to the operand that will be entered next.
     * Go to error if the number in the display does not parse properly into a floating point number.
     * @param calc The calculator model (context)
     * @param op New pending operation
     */
    public void enterOp(InfixCalc calc, IBinOp op) {
        try {
            calc.setAcc(calc.getPendingOp().compute(calc.getAcc(), Double.parseDouble(calc.getDisplay())));
            calc.setDisplay("" + calc.getAcc());
            calc.setPendingOp(op);
        }
        catch (Exception e) {
            calc.setDisplay(e.getMessage());
            calc.setCurState(ErrorState);
        };
    }
    
    /**
     * Syntax error.  Set display to "Syntax error" and
     * go to error state.
     * @param calc The calculator model (context)
     */
    public void enterEqual(InfixCalc calc) {
        calc.setDisplay("Syntax Error!");
        calc.setCurState(ErrorState);
    }
    
    
    /**
     * Enters a decimal point.  Set display ot "0." and go to point state.
     * @param calc The calculator model (context)
     */
    public void enterPoint(InfixCalc calc) {
        calc.setDisplay("0.");
        calc.setCurState(PointState.Singleton);
    }
}

