
package infixModel;

/**
 * State where a decimal point has been entered.
 * Decorating AccumState!   Delegates to an accumulating state object for 
 * operations that are identical.
 */
class PointState extends ACalcState {
    
    /**
     * Reference to accumulating state for delegation purposes.
     */
    static final AccumState AccState = AccumState.Singleton;
    /**
     * Singleton instance
     */
    static final PointState Singleton = new PointState();
    /**
     * Hidden constructor
     */
    private PointState() {
    }
    
    /**
     * Keeps on accumulating c.  Same as accumlating state.
     * @param calc The calculator model (context)
     * @param c The digit being entered
     */
    public void enterDigit(InfixCalc calc, char c) {
        //        System.out.println("Point State: enter character " + c);
        AccState.enterDigit(calc, c);
    }
    
    /**
     * Performs the pending operation, and set op as the next pending operation
     * on whatever is computed so far to the operand that will be entered next.
     * Go to error if the number in the display does not parse properly into a floating point number.
     * Same as accumulating state.
     * @param calc The calculator model (context)
     * @param op 
     */
    public void enterOp(InfixCalc calc, IBinOp op) {
        AccState.enterOp(calc, op);
    }
    
    /**
     * Computes the pending operation.
     * Same as accumulating state.
     * @param calc The calculator model (context)
     */
    public void enterEqual(InfixCalc calc) {
        AccState.enterEqual(calc);
    }
    
    /**
     * Does nothing because a decimal point has already been entered.
     * @param calc The calculator model (context)
     */
    public void enterPoint(InfixCalc calc) {
        // do nothing
    }
}

